function [V_total, E_total] = hamiltonian_XState_hfs(Fn_X, J_X, I, F_X)

% Finds mixing coefficients for the X state by solving the hamiltonian
% Fn_X --> F2/F1 manifold to which the state whose mixing is studied
% J_X  --> J quantum number of the state
% I    --> Nuclear spin quantum number (0 or 2)
% F_X  --> Hyperfine quantum number of the state

disp_flag = 1; % Flag for printing output

F = F_X;
S = 0.5;

%% Constants

% B = 1.922316; %    [cm-1] - Taken from Mathias Germann PhD thesis
% D = 0.5919e-5;%    [cm-1] - Taken from Mathias Germann PhD thesis
% g = 280.25; %      [MHz] - Taken from Mathias Germann PhD thesis

B = 1.9223897; %    [cm-1] - Taken from Wu07
D = 5.9748e-6; %    [cm-1] - Taken from Wu07
g = 9.1965e-3; %    [cm-1] - Taken from Wu07
% g = 0;         %    [cm-1] - To Turn off interaction


bF = 102.4; %       [MHz] - Taken from Mathias Germann PhD thesis
% bF = 0; %          [MHz] - To Turn off interaction


cl = 299792458; %           [m/s] speed of light
bF = ((bF*1e6)/cl)/100; %   [cm-1]
%g = ((g*1e6)/cl)/100; %    [cm-1]

% if (N_X == J_X + 1/2)
%     Fn = 2;
% elseif (N_X == J_X - 1/2)
%     Fn = 1;
% else
%     disp('Error in N_X');
% end

% Generating N quatum number

if (Fn_X == 2)
    N_X = J_X + 1/2 ;
elseif (Fn_X == 1)
    N_X = J_X - 1/2 ;
else
    disp('Error in Fn_X');
end


%% Hamiltonian
N = N_X;
% if (Fn_X == 1) % For F1 states
%     E_fs = B*N*(N+1) - D*(N*(N+1))^2 + 0.5*g*N;
%     E_t = [0 0; 0 E_fs];
% else % For F2 states
%     E_fs = B*N*(N+1) - D*(N*(N+1))^2 - 0.5*g*(N+1);
%     E_t = [E_fs 0; 0 0];
% end


% All Hamiltonian except Hyperfine
% Taken from Mathias Germann PhD thesis


E_t = [B*N*(N+1) - D*(N*(N+1))^2 - 0.5*g*(N+1), 0; 0, B*N*(N+1) - D*(N*(N+1))^2 + 0.5*g*(N)];

% Size of matrix.
% If N'' = 0 and J'' = 1/2, 1x1 matrix
% else 2x2

if ((J_X == 1/2)&&(N == 0))
    index = 1;
else
    index = 2;
end

H_hfs = @(J_i, J_j) bF * (-1)^(F+I+J_j+J_i+N_X+0.5+1) *...
    sqrt( I*(I+1)*(2*I + 1)*S*(S+1)*(2*S+1)*(2*J_i+1)*(2*J_j+1) )*...
    Wigner6j(I, J_j, F, J_i, I, 1)*Wigner6j(S, J_j, N_X, J_i, S, 1);


% <F2|H|F2>    <F2|H|F1>
% <F1|H|F2>    <F1|H|F1>

% Only negative parity states are calculated since only these were needed
% for our transitions

if (index == 2)
    for i = 1:1:index
        for j = 1:1:index
            if ((i == 1)&&(j == 1))
                J_i = N_X - 1/2;            % F2 transition
                J_j = N_X - 1/2;            % F2 transition
                H11 = H_hfs(J_i, J_j);
            elseif ((i == 1)&&(j == 2))
                J_i = N_X - 1/2;            % F2 transition
                J_j = N_X + 1/2;            % F1 transition
                H12 = H_hfs(J_i, J_j);
            elseif ((i == 2)&&(j == 1))
                J_i = N_X + 1/2;            % F1 transition
                J_j = N_X - 1/2;            % F2 transition
                H21 = H_hfs(J_i, J_j);
            else
                J_i = N_X + 1/2;            % F1 transition
                J_j = N_X + 1/2;            % F1 transition
                H22 = H_hfs(J_i, J_j);
            end
            
        end
    end
    
    H_hfs_total = E_t + [H11 H12; H21 H22];
    [V, D] = eig(H_hfs_total);
    if (disp_flag == 1)
        disp('---------- For X State ---------------');
    end
    if (Fn_X == 2)
        %E_total = E_fs + D(1,1);
        E_total = D(1,1);
        V_total = V(:,1);
        if (disp_flag == 1)
            disp(['Energy of F2, J = ', num2str(J_X*2), '/2 state is: ', num2str(E_total*100*cl/1e6), ' MHz']);
            disp('Mixing coefficients');
            disp(['With F2, J = ', num2str((J_X)*2), '/2 : ', num2str(V_total(1))]);
            disp(['With F1, J = ', num2str((J_X+1)*2), '/2 : ', num2str(V_total(2))]);
        end
    else
        %E_total = E_fs + D(2,2);
        E_total = D(2,2);
        V_total = V(:,2);
        if (disp_flag == 1)
            disp(['Energy of F1, J = ', num2str(J_X*2), '/2 state is: ', num2str(E_total*100*cl/1e6), ' MHz']);
            disp('Mixing coefficients');
            disp(['With F2, J = ', num2str((J_X-1)*2), '/2 : ', num2str(V_total(1))]);
            disp(['With F1, J = ', num2str((J_X)*2), '/2 : ', num2str(V_total(2))]);
        end
    end
else
    E_total = E_t(2,2) + H_hfs(N_X + 1/2, N_X + 1/2);
    V_total = [0 1];
    if (disp_flag == 1)
        disp(['Energy of F1, J = ', num2str(J_X*2), '/2 state is: ', num2str(E_total*100*cl/1e6), ' MHz']);
        disp('Pure state (No mixing)');
        disp(['With F1, J = ', num2str((J_X)*2), '/2 : ', num2str(V_total(2))]);
    end
end



end
